<CsoundSynthesizer>
<CsOptions>
</CsOptions>
<CsInstruments>
; face on mars - michael bergeman
sr = 44100 
kr = 2205                                 
ksmps = 20
nchnls = 2

garvbsig1  init 0
garvbsig2  init 0
garvbsig3  init 0
garvbsig4  init 0

instr 1
idb=ampdb(p4)
isc=idb*.333
k1 line 40,p3,800 
k2 line 440,p3,220
k3 linen isc,p6,p3,p7
k4 line 800,p3,40 
k5 line 220,p3,440  
k6 linen isc,p6,p3,p7
a5 oscil k3,p8,p5
a6 oscil k3,p8*.999,p5
a7 oscil k3,p8*1.001,p5
a1=a5+a6+a7  
a8 oscil k6,p9,p5
a9 oscil k6,p9*.999,p5
a10 oscil k6,p9*1.001,p5
a11=a8+a9+a10
a2 butterbp a1,k1,40
a3 butterbp a2,k5,k2*.8
a4 balance a3,a1
a12 butterbp a11,k4,40
a13 butterbp a12,k2,k5*.8
a14 balance a13,a11
outs a4,a14
endin

instr 2
idb1=ampdb(p9)
idb2=ampdb(p11)
irvgain1=p12
irvgain2=p13
k1 oscil idb1,1/p3,p8
k2 oscil idb2,1/p3,p10
k3 linen  3,.9,p3,.3
k4 randi k3,10
k5 randi k3,15
k6 linen p20,p14,p3,p16
k7 linen p21,p15,p3,p17
k8 oscil k6,p18,1
k9 oscil k7,p19,1
a1 oscil k1,p4+k4+k8,p5
a2 oscil k2,p6+k5+k9,p7
outs a1,a2
garvbsig1 = garvbsig1+a1*irvgain1
garvbsig2 = garvbsig2+a2*irvgain2
endin
instr 3
ifunc=p4
imeth=p5
iamp= ampdb(p6)
iseed= p7
ilforate=p8
ita=23
itb=24
itc=25
itd=26

if (imeth==1) kgoto randoma
if (imeth==2) kgoto randomb
if (imeth==3) kgoto randomc
if (imeth==4) kgoto randomd

randoma:        kindex  randh  int(10), ilforate, iseed
                kpitch  table   abs(kindex), ita
kgoto next

randomb:        kindex  randh  int(18), ilforate, iseed
                kpitch  table   abs(kindex), itb
kgoto next

randomc:        kindex  randh  int(9), ilforate, iseed
                kpitch  table   abs(kindex), itc
kgoto next

randomd:        kindex  randh  int(6), ilforate, iseed
                kpitch  table   abs(kindex), itd
kgoto next

next:    if p6<50 kgoto ra
         if p6>49 kgoto rb
             
ra: k1 linen iamp,.25*p3,p3,.2*p3
    k2 linen iamp,.2*p3,p3,.25*p3
    k5 line   1500,p3,50
    k6 line   1000,p3,50
    a1 oscil k1,kpitch,ifunc
    a2 oscil k2,kpitch*1.002,ifunc
    a5 butterbp a1,k5,30
    a6 butterbp a2,k6,25
    a7 balance a5,a1
    a8 balance a6,a2
    outs a7,a8
garvbsig3=garvbsig3+(a1+a2)*4

rb: k3 linen iamp,.25*p3,p3,.2*p3
    k4 linen iamp,.2*p3,p3,.25*p3
    k7 line  1500,p3,50
    k8 line  1500,p3,50
    a3 oscil k3,kpitch,ifunc
    a4 oscil k4,kpitch*.998,ifunc
    a9  butterbp a3,k7,25
    a10 butterbp a4,k8,25
    a11 balance a9,a3
    a12 balance a10,a4
    outs a11,a12
garvbsig4=garvbsig4+(a3+a4)*2                               
endin
instr 96
irvtime=p4
a1  reverb2 garvbsig3,irvtime,.9
k1  line  50,p3,2500
a13 butterbr a1,k1,10
a14 balance a13,a1 
outs a14,(a14)*0
garvbsig3=0
endin
instr 97
irvtime=p4
a1  reverb2 garvbsig4,irvtime,.1 
k1  line 2500,p3,100
a13 butterbr a1,k1,50
a14 balance a13,a1 
outs (a14)*0,a14
garvbsig4=0
endin

instr 98
irvtime=p4
a1  reverb2 garvbsig1,irvtime,.5
outs a1,(a1)*0
garvbsig1=0
endin
instr 99
irvtime=p4
a1  reverb2 garvbsig2,irvtime,.25
outs (a1)*0,a1
garvbsig2=0
endin



</CsInstruments>
<CsScore>
f1 0 4096 10 1
f2 0 4096 10 .45 .31 .38 .9 .32 .28 0 0 .2 .18 0 0 0 0 .2 .3 .4 .24 .24 .24 .3
f3 0 4096 10 .86 .9 .32 .2 0 0 0 0 0 0 0 0 0 .3 .5
f4 0 4096 10 .34 .9 .88 .32 0 .32 0 .32 0 .22 .29 0 .29 0 .29 0 .52 0 .34 0 .49 0 .52
f5 0 4096 10 .52 0 .86 0 .2 .156 0 .156 0 0 .156 0 .156 0 .28 0 .48 0 .4 0 .7 0 .22
f6 0 4096 10 .3 .3 .44 .34 .56 .3 .06 .03
f7 0 4096 10 .28 1 .74 .66 .78 .48 .05 .33 .12 .08 .01 .54 .19 .08 .05 .16 .01 .11 .3 .02 .2
f8 0 4096 10 .6 .4 1 .22 .09 .24 .02 .06 .05
f9 0 4096 10 1 .41 .95 .45 .18 0 .05
f10 0 4096 10 1 1 .1 .2 .156 .02 .02 .02
f11 0 4096 10 1 0 .5 .1 .6 .3 .5 .3 .1 .01
f12 0 4096 10 1 .7 .12 .5 .08 0 0 .02 .05 0 0 .03
f13 0 4096 10 .9 1 .2 .1 .3 .1 0 0 .05
f14 0 4096 10 .3 .1 .6 .15
f15 0 4096 10 1 0 0 0 0 0 1 0 0 0 1 0           
f16 0 512 7 0   128 1 128 .7 128 .7 128  0
f17 0 512 5 .01 128 1 128 .7 128 .7 128 .01
f18 0 512 7 1   128 .8 128  .6 128  .4  64  .2 64 0
f19 0 512 5 1   128 .8 128  .4  64  .6  32  .2 32 .4 64 .2 64 .01
f20 0 512 7 0 128 1 128 .7 128 .5 128 0
f21 0 512 7 0  64 1 128 .8 64 .6 128 .4 128 0
f22 0 512 7 0   128 .5 128 1 128 .7 128 0
f23 0  9 -2 110 146.6 165  293 330 440 586.4 660 880
f24 0 17 -2 27.5  41.25 55 73.3 82.5 110 146.6 165 220 293 330 440 586.4 660 880 1172.8 1320
f25 0  8 -2 220 293 330 440 586.4 660 1172.8 1320   
f26 0  5 -2 27.5 36.65 41.25 55 73.3 82.5 
;ins  st  dur   revti
 i98  0   163    3
 i99  0   165    5
;ins  st  dur  db func   at  dec freq1  freq2
  i1   0   10   75  7    .9   4   27.5   27.51
  i1   5   10   75  15   .9   6    .       .
  i1   6   14   75  4     4   5    .       .
  i1  12   13   75  5     4   4    .       .
  i1  15   15   75  12    5   5   30.9   31
  i1  15   15   75   2    8   5   .       .
  i1  28   12   75  7     4   4   27.5   27.51 
;ins  st  dur  freq1 func1 freq2 func2  fuen1 db1 fuen2 db2 revg1 revg2 va1 va2 vd1 vd2 vr1 vr2 vi1 vi2   
  i2   0   5.4  146.7  2    220    4      16   73   16   43   .9    9    0   0  0   0   0   0   0   0
  i2   5   .    165    2    165.5  6      20   63   21   53  2.5    5    2   3  .5 .3   4   2   2   3
  i2  10    5   220    3    220    3      16   53   22   63   5    2.5   .   .  .   .   9  11   2   3
  i2  15   10   165    3    165    3      21   43   20   70   9     .9   3   2  1   2  15  10   6   4
  i2  28   12   220    4    220.2  2      16   43   16   43   7     7    5   7  2   3  13   9   8   2
  i2  28   12   110    2    110.18 3      17   43   17   43   7     7    3   5  1   2  11   4   6   8
  i2  36   10   880    2    881    3      17   43   17   43   7     7    3   5  1   2  11   4   6   8
  i2  40    8   988    2    990    3      16   43   17   43   7     7    3   5  1   2  11   4   6   8
  i2  44    9   880    2    988    3      17   53   17   43   7     7    3   5  1   2  11   4   6   8   
  i2  50.4  5   123.75 3    124.5  2      21   63   20   63   3     3    2   1  1   2   6   2   4   2
  i2  50.4  5   247.5  6    249    4      19   53   18   58   3     3    1  .5  2   3   2   1   5   3
  i2  50.4 10.6 30.9  14     30    9      18   60   20   60   1     2    8   0 .5   0   4   0   1   0
  i2  53    8   371.25 2    330    6      16   50   21   53   5     5    5   3  2  .5   5   2   3   5
  i2  55    6   556.9  5    278.4  2      16   58   17   53   5     5    4   5 .8  .2   7   4   4   6
  i2  63   10   371.25 3    330    3      16   58   17   58   2     2    2   4  2   3   5   2   5   7                    
  i2  .     .   370.50 3    333    3      20   58   21   58   2     2    3   5  1   2   2   1   6   6         
  i2  .     .   495    2    497    5      16   53   17   53   2     2    2   4  4   2   4   6   8   4
  i2  .     .   497    4    498    6      16   58   17   53   2     2    1   2  4   8   9   6   4   2
  i2  .     .    55   14    55.5   9      18   60   20   60   2     2    8   0 .5   0   4   0   1   0
  i2  72   11   61.87  9    62.5  14      22   70   22   70  .7    .7    0   2  0   8   0   6   0   5
  i2  72   11   555    6    556    6      16   61   16   61  .6    .8    2   4  6   4   5   7   7   5
  i2  .     .   554    3    555    2      16   62   17   63  .7    .5    1   5  8   3   3   2   5   6
  i2  .     .   371.25 6    372.5  5      20   62   21   61  .5    .7    2   7  7   2   7   7   5   2
  i2  .     .   412    4    557    3      16   62   22   64  .3    .8    7   2  2   6   5   3   3   2
  i2  .     .   278    3    278    3      22   63   18   53  .8    .8    2   3 .5  .3   4   2   2   3 
  i2  82   15   69.6   2    70     2      16   63   17   63  .6    .6    2   3  8   7   3   2   1   1
  i2  82    .   624.37 5    626    6      17   53   17   63  .6    .6    4   6  6   3   2   1   1   4
  i2  82    .   312.18 3    313    3      20   63   21   58  .5    .6    3   2  3   2   4   2   2   2
  i2  83   14   417.65 4    835.31 6      17   63   16   63  .7    .8    4   4  4   4   5   3   7   4
  i2  84   13   463.5  2    702.4  3      16   68   17   63  .8     .    3   8  3   2   3   1   1   2
  i2  85   12   835.3  3    835.3  3      22   50   16   60  .8     .   12  14 .5  .2   4.5 9  10  20
  i2  95 .125   835.3  5     880   2       .   50    .    40   . . . . . . . . . .
  i2  +     .   880   13    835.3 10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .   835.3  7     880   4       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    6    835.3  5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   835.3  5     880   6       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    2     835.3 7       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .   835.3  3     880   8       .    <    .     <   . . . . . . . . . .  
  i2  +     .   880    3    835.3  9       .   80    .     <   . . . . . . . . . .
  i2  96 .125   835.3  5     870   2       .    <    .     <   . . . . . . . . . .
  i2  +     .   880   13    825.3 10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .   835.3  7     860   4       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    6    815.3  5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   835.3  5     850   6       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    2     805.3 7       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .   835.3  3     840   8       .    <    .     <   . . . . . . . . . .  
  i2  +     .   880    3    795.3  9       .   50    .    80   . . . . . . . . . .
  i2  97 .125   835.3  5     830   2       .    <    .    75   . . . . . . . . . .
  i2  +     .   880   13    785.3 10      17    <   17    70  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .   835.3  7     820   4       .    <    .    65   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    6    775.3  5       .    <    .    64   .     .    .   .   .   .  .   .   .   .
  i2  +     .   835.3  5     810   6       .    <    .    63   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    2    765.3  7       .    <    .    62   .     .    .   .   .   .  .   .   .   . 
  i2  +     .   835.3  3     800   8       .    <    .    61   . . . . . . . . . .  
  i2  +     .   880    3    755.3  9       .   40    .    60   . . . . . . . . . .
  i2  98 .125   835.3  5     790   2       .    <    .     <   . . . . . . . . . .
  i2  +     .   880   13    745.3 10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .   835.3  7     780   4       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    6    745.3  5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   835.3  5     780   6       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .   880    2     745.3 7       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .   835.3  3     780   8       .    <    .     <   . . . . . . . . . .  
  i2  +     .   880    3    745.3  9       .   30    .    30   . . . . . . . . . .
 ;ins  st  dur  db func   at  dec freq1  freq2  
  i1  40   20   63   4    2   2   480    720  
  i1  40   20   63   5    4   4   720    481
  i1  40   20   75  12    2   2   30.9   31
  i1  40   15   73   2    8   5   .       .
  i1  40    1   73  12   .5  .1   31     31
  i1   +   .9    <   2   .4  .09   <     <
  i1   +   .8    <  12   .3  .07   <     <
  i1   +   .7    <   2   .2  .05   <     <
  i1   +   .6    <  12   .1  .03   <     <
  i1   +   .5    <   2   .09 .01   <     <
  i1   +   .4    <  12   .   .     <     <
  i1   +   .3    <   2   .   .     <     <
  i1   +   .25   <  12   .   .     <     <
  i1   +   .     63 12   .   .     <     <
  i1   +   .     <  12   .   .     .     960
  i1   +   .     <  12   .   .     .     .              
  i1   +   .     <  12   .   .     <     .
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .    960    <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     73 12   .   .     <     <
  i1   +   .     <  12   .   .     <     <              
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     .     .
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <               
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     <  12   .   .     <     <
  i1   +   .     53 12   .   .    30.3   31
  i1  45.4 8.6   .   2   .6  4    31     31
  i1  82   15    80  2   4   5    34.8   34.8 
  i1  82    3    70  3  .5  .5    69.6  139.2
  i1  85    2    69  4  .3  .3   139.2   69.6
  i1  87    2    68  5  .2  .2    69.6  139.2
  i1  89    2    67  2  .1  .1   139.2   69.6
  i1  91    2    66  3  .2  .2    69.6  139.2
  i1  93    2    68  4  .3  .3   139.2   69.6
  i1  95    2    70  5  .2  .2   139.2  139.2
  i1  82   15    80  14  5  .5    34.8   34.8
  i1  94    3    65  15  1   1    69.6   69.6 
 ;ins  st  dur   revti
  i96   97  63.2 .2
  i97   97  63.4 .4
 ;ins  st  dur  func meth db seed rasp    
  i3   97  36   13    3    40  .2    4
  i3   97  12   13    3    40  .2    4
  i3   97  12    3    1    45  .1    8
  i3   97  12    9    2    44  .4    4
  i3   97  12   12    3    43  .3    2
  i3  109  12   11    3    55  .2    4
  i3  110  11    3    1    46  .5    8
  i3  111  10   13    3    55  .6    2
  i3  112   9    6    1    45  .7    2
  i3  113   8    7    .    45  .8    1
  i3  114   7    8    2    44  .9   .5
  i3  115   6    9    .    43  .12  .5
  i3  116   5    2    1    42  .63   2
  i3  117   4   12    3    50  .34   4
  i3  118   3    4    1    41  .43   8
  i3  121  12    2    1    42  .14   2
  i3  121  12    6    1    43  .55   4
  i3  121  12   13    3    44  .56   2
  i3  121  12   12    .    45  .27   4
  i3 97.5 11.5   3    1    44  .1    8
  i3   .   .     9    2    43  .4    4
  i3   .   .    12    3    42  .3    2
  i3 109.5 .    11    3    43  .2    4
  i3 110.5 10.5  3    1    44  .5    8
  i3 111.5  9.5 13    3    55  .6    2
  i3 112.5  8.5  6    1    45  .7    2
  i3 113.5  7.5  7    .    45  .8    1
  i3 114.5  6.5  8    2    44  .9   .5
  i3 115.5  5.5  9    .    43  .12  .5
  i3 116.5  4.5  2    1    42  .63   2
  i3 117.5  3.5 12    3    50  .34   4
  i3 118.5  2.5  4    1    41  .43   8
  i3 121.5 11.5  2    1    45  .14   2
  i3   .   10.5  6    1    44  .55   4
  i3   .    9.5 13    3    43  .56   2
  i3   .    8.5 12    .    42  .27   4
 ;ins  st  dur  db func   at  dec freq1  freq2
  i1   97  12   80  14    .3   1   28.5   27.5
  i1   97  12   80  14    .3   1   27     28 
  i1  109  12   80  14    .3   1   42     41 
  i1   .   12   80  14    .3   1   41.25  42.25
  i1  121  12   80  14    .3   1   56.5   55.5        
  i1  121  12   80  14    .3   1   55     56  
 ;ins  st  dur  freq1 func1 freq2 func2  fuen1 db1 fuen2 db2 revg1 revg2 va1 va2 vd1 vd2 vr1 vr2 vi1 vi2   
  i2   97  12   220    3     222   3      22   60   21    60  .3    .3    2   4   2   2   3   6   6   4
  i2   97  12   219    3     221   3      20   60   21    60  .     .     6   3   2   1   3   5   8   4
  i2   97  12   880    6     882   6      22   55   21    55  .     .     8   4   2   1   3   6   6   4
  i2   97  12   885    3     878   3      22   60   21    60  .     .     8   4   2   1   3   6   6   4
  i2   97  12   218    3     223   3      22   60   21    60  .     .     1   6   2   2   3   6   6   4
  i2  109  12   330    3     330   3      22   60   22    60  .     .     4   8   2   1   4   2   3   6
  i2  109  12   331    3     329   3      21   60   20    60  .     .     2   4   6   8   6   8   3   3
  i2  109  12   660    2     662   2      22   55   22    55  .     .     5   5   6   4   3   3   2   3
  i2  109  12   835.3  3     835.3 3      22   60   16    60  .     .     6   6   2   4   2   5   5   2
  i2  121  12   440    3     441   3      22   60   21    60  .     .     3   3   1   2   3   5   7   5
  i2  121  12   441    3     439   3      16   60   17    60  .     .     2   1   5   6   3   2   3   3
  i2  121  12   880    4     880   5      22   50   22    50  .     .     3   3   3   3   3   3   3   3
  i2  121  12   220    6     440   2      22   55   22    60  .     .     2   1   4   5   3   6   7   8
  i2   97  4.3  440   13     440   7      22   70   22    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2   97  4.3  440    3     440   3      22   75   22    75  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  101   1   391   13     392   7      19   70   18    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  101   1   391    3     392   3      22   75   22    75  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  102   1   521   13     522   7      19   70   18    70  .2    .2    .5  .2  .1  .1  3   6   4   4   
  i2  102   1   521    3     522   3      22   75   22    75  .2    .2    .5  .2  .1  .1  3   6   4   4   
  i2  103   1   495   13     496   7      19   70   18    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  103   1   495    3     496   3      22   75   22    75  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  104   1   392   13     391   7      18   70   19    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  104   1   392    3     391   3      22   75   22    75  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  105  4.3  440   13     440   7      22   70   22    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  105  4.3  440    3     440   3      22   75   22    75  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  109  4.3  412    7     413  13      22   70   22    70  .     .     .6  .3  .3  .7  3   4   5   6
  i2  109  4.2  412    3     413   3      22   75   22    75  .     .     .6  .3  .3  .7  3   4   5   6
  i2  113   1   391    7     392  13      19   70   19    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  114   1   521    .     522   .      18   70   19    70  .2    .2    .5  .2  .1  .1  3   6   4   4   
  i2  115   1   495    .     496   .      18   70   18    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  116   1   392    .     391   .      19   70   18    70  .2    .2    .5  .2  .1  .1  3   6   4   4 
  i2  117  4.3  413    .     412   .      22   70   22    70  .     .     .6  .3  .3  .7  3   4   5   6
  i2  121  6.2  391    .     392   .      21   70   21    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  127   6   440    .     441   .      22   70   22    70  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  113   1   391    3     392   3      22   75    .    75  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  114   1   521    .     522   .       .    .    .     .  .2    .2    .5  .2  .1  .1  3   6   4   4   
  i2  115   1   495    .     496   .       .    .    .     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  116   1   392    .     391   .       .    .    .     .  .2    .2    .5  .2  .1  .1  3   6   4   4 
  i2  117  4.3  413    .     412   .      22    .   22     .  .     .     .6  .3  .3  .7  3   4   5   6
  i2  121  6.2  391    .     392   .       .    .    .     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2  127   6   440    .     441   .      22    .   22     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 97.5  4.3 1760   10    1760  10      22   60   22    60  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 101.5  1  1562    .    1570   .      19    .   18     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 102.5  .  2084    .    2090   .      19    .   18     .  .2    .2    .5  .2  .1  .1  3   6   4   4   
  i2 103.5  1  1990    .    1980   .      19    .   18     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 104.5  1  1570    .    1580   .      18    .   19     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 105.5 4.3 1760    .    1770   .      22    .   22     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 109.5 4.3 1650    .    1660   .      22    .   22     .  .     .     .6  .3  .3  .7  3   4   5   6
  i2 113.5  1  1570    .    1560   .      19    .   19     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 114.5  1  2088    .    2095   .      18    .   19     .  .2    .2    .5  .2  .1  .1  3   6   4   4   
  i2 115.5  1  1984    .    1990   .      18    .   18     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 116.5  1  1568    .    1570   .      19    .   18     .  .2    .2    .5  .2  .1  .1  3   6   4   4 
  i2 117.5 4.3  1654   .    1660   .      22    .   22     .  .     .     .6  .3  .3  .7  3   4   5   6
  i2 121.5  5.8 1564   .    1560   .      21    .   21     .  .2    .2    .5  .2  .1  .1  3   6   4   4
  i2 109 .125  1572    4    1579  11       .   15    .    15  .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    5    1779  12       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    8    1565  13       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    7    1770  14       .    <    .    <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    6    1560  15       .    <    .    <   . . . . . . . . . .  
  i2  +     .  1764    9    1769   3       .    <    .    <   . . . . . . . . . .
  i2  +     .  1568    5    1560   2       .    <    .    <   . . . . . . . . . .
  i2  +     .  1770   13    1775  10      17    <   17    <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    <    .    <   .     .    .   .   .   .  .   .   .   .  i2  +     .  1776    2    1770   7       .    <    .    <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    <    .    <   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    <    .    <   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    <    .    <   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    <   17    <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .   35    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    <    .    <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    <    .    <   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    <    .    <   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    <    .    <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    <   17    <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572   14    1579   9       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772   12    1779   8       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570   14    1565   7       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776   15    1770   6       .    <    .    <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564   14    1560   6       .    <    .    35     . . . . . . . . . .  
  i2  +     .  1764   14    1769   5       .    <    .    <   . . . . . . . . . .
  i2  +     .  1568   13    1560   4       .    <    .    <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    <   17    <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572   12    1579   4       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772   11    1779   3       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    9    1565   2       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    8    1770   3       .    <    .    <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    7    1560   5       .    <    .    <   . . . . . . . . . .  
  i2  +     .  1764    5    1769   6       .    <    .    <   . . . . . . . . . .
  i2  +     .  1568    6    1560   7       .    <    .    <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    <   17    <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    5    1579  13       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    8    1779  14       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    7    1565   5       .    <    .    <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    4    1770  15       .    <    .    <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    5    1560   4       .    <    .    <   . . . . . . . . . .  
  i2  +     .  1764    2    1769   3       .    <    .    <   . . . . . . . . . .
  i2  +     .  1564    5    1560   4       .    <    .    <    . . . . . . . . . .  
  i2  +     .  1764    2    1769   3       .   20    .    25   . . . . . . . . . .
  i2 127    .  1760    3    1770   3      22   62   22    70  .2    .2    .05 .06 .06 .07 .   .   .   .
  i2  +     .  1572    4    1579  11       .   65    .    69   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    5    1779  12       .   64    .    68   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    8    1565  13       .   64    .    67   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    7    1770  14       .   64    .    66   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    6    1560  15       .   65    .    65   . . . . . . . . . .  
  i2  +     .  1764    9    1769   3       .   66    .    66   . . . . . . . . . .
  i2  +     .  1568    5    1560   2       .   67    .    67   . . . . . . . . . .
  i2  +     .  1770   13    1775  10      17   62   17    68  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .   61    .    69   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .   62    .    68   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .   63    .    67   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .   64    .    66   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .   65    .    65   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .   66    .    66   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .   67    .    67   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17   66   17    68  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .   65    .    69   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .   64    .    68   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .   64    .    67   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .   64    .    66   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .   65    .    65   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .   66    .    66   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .   67    .    67   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17   66   17    68  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572   14    1579   9       .   65    .    69   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772   12    1779   8       .   64    .    68   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570   14    1565   7       .   64    .    67   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776   15    1770   6       .   64    .    66   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564   14    1560   6       .   65    .    65   . . . . . . . . . .  
  i2  +     .  1764   14    1769   5       .   66    .    66   . . . . . . . . . .
  i2  +     .  1568   13    1560   4       .   67    .    67   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17   60   17    68  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572   12    1579   4       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772   11    1779   3       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    9    1565   2       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    8    1770   3       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    7    1560   5       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    5    1769   6       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568    6    1560   7       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    5    1579  13       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    8    1779  14       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    7    1565   5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    4    1770  15       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    5    1560   4       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    2    1769   3       .    <    .     <   . . . . . . . . . .
  i2 132.875 . 1568    .    1560   .       .   40    .    45   . . . . . . . . . .
 
 
;ins  st  dur  freq1 func1 freq2 func2  fuen1 db1 fuen2 db2 revg1 revg2 va1 va2 vd1 vd2 vr1 vr2 vi1 vi2    
 i2  136   2    55    8     55.5   8     17   60   20   60   1     1     0   0   0   0   0   0   0   0
 i2  136   2   110   13     111   14     17   55   22   55   2     2    .5  .4  .4  .5  12  11   2   1
 i2  136   2   183.3  3     184    6     22   50   21   50   3     3    .4  .2  .2  .4  13  12   3   2
 i2  136   2   293.3 11     294    9     16   55   17   55  .8    .8     0   0   0   0   0   0   0   0
 i2  136   2   660    6     664    6     21   60   20   60   2     2    .6  .3  .6  .3  10  12   1   1
 i2  136   2  54.5    9     54.8   8     17   50   20   50   1     1     0   0   0   0   0   0   0   0
 i2  136   2   109   13     108   14     17   45   22   45   2     2    .5  .4  .4  .5  12  11   2   1
 i2  136   2   182.3 14     181    6     22   40   21   40   3     3    .4  .2  .2  .4  13  12   3   2
 i2  136   2   293.9 11     293    8     18   35   19   35  .8    .8     0   0   0   0   0   0   0   0
 i2  136   2   659    5     665    4     21   40   20   40   2     2    .6  .3  .6  .3  10  12   1   1
 i2  140   2    55    9     55.7   9     18   60   19   60   1     1     0   0   0   0   0   0   0   0
 i2  140   4   330    3     331   10     16   55   17   55   2     2    .4  .2  .2  .4   9   7   2   2 
 i2  140   4   412   11     412.5 12     21   55   20   55   2     2    .5  .1  .2  .4   5  10   1   1 
 i2  140   4   440   13     442   14     22   55   22   55   2     2    .8  .4  .2  .4  11   6   1   2 
 i2  140   4   586    2     587    3     16   55   17   55   2     2    .4  .2  .2  .4   6   6   2   1 
 i2  140   2   55.2    9     55.4   9     18   50   19   50   1     1     0   0   0   0   0   0   0   0
 i2  140   4   333    3     329   10     16   45   17   45   2     2    .4  .2  .2  .4   9   7   2   2 
 i2  140   4   414    7     411   12     21   45   20   45   2     2    .5  .1  .2  .4   5  10   1   1 
 i2  140   4   439   13     438   14     22   45   22   45   2     2    .8  .4  .2  .4  11   6   1   2 
 i2  140   4   584    2     583    3     16   45   17   45   2     2    .4  .2  .2  .4   6   6   2   1 
 i2  142   2  41.25   9    41.65   9     18   60   19   60   1     1     0   0   0   0   0   0   0   0
 i2  140   4   660   10     331   13     16   45   17   45   2     2    .4  .2  .2  .4   9   7   2   2 
 i2  140   4   412    7     412.5  6     21   45   20   45   2     2    .5  .1  .2  .4   5  10   1   1 
 i2  140   4   440   11     442   14     22   45   22   45   2     2    .8  .4  .2  .4  11   6   1   2 
 i2  140   4   586    7     587    3     16   45   17   45   2     2    .4  .2  .2  .4   6   6   2   1  
 i2  142   2  41.15   9    41.35   9     18   50   19   50   1     1     0   0   0   0   0   0   0   0
 i2  140   4   661   12     330   13     16   35   17   35   2     2    .4  .2  .2  .4   9   7   2   2 
 i2  140   4   411    7     410.5  6     21   35   20   35   2     2    .5  .1  .2  .4   5  10   1   1 
 i2  140   4   443   11     439   14     22   35   22   35   2     2    .8  .4  .2  .4  11   6   1   2 
 i2  140   4   585    7     588   13     16   35   17   35   2     2    .4  .2  .2  .4   6   6   2   1  
 i2  144  16   880    3     883    3     16   35   16   35   3     3     .   .   .   .   .   .   1   1
 i2  148  12    55    9     55.5   9     17   60   19   60   1     1     0   0   0   0   0   0   0   0
 i2 148.1 11.9 330    2     332    4     22   50   22   50   2     2     5   4   3   1   5   3   1   1
 i2  148  12   550    3     552    3     16   65   17   55   2     2     5   6   2   2   5   8   1   2
 i2  148  12   586.6  5     880    6     21   55   22   55   2     2     .   .   .   .   .   .   .   1
 i2  148  12   1760   7    1760   10     16   50   17   50   2     2     .   .   .   .   3   1   1   1
 i2  148  12   275   13     278   12     17   55   20   55   1     2     3   6   6   3   7   9   2   1
 i2  148  12  55.4    9     55.6   9     18   60   17   60   1     1     0   0   0   0   0   0   0   0
 i2 148.4 11.6 329    2     333    4     22   40   22   50   2     2     5   4   3   1   5   3   1   1
 i2 148   12   551   13     549   14     20   50   17   45   2     2     5   6   2   2   5   8   1   2
 i2 148.7 11.3 587.6  5     881    6     21   50   22   45   2     2     .   .   .   .   .   .   .   1
 i2 149.2 10.7 1761  11    1762   10     16   50   17   50   2     2     .   .   .   .   3   1   1   1
 i2 149.6 10.4 274    7     279    7     16   45   20   45   1     2     3   6   6   3   7   9   2   1  
;ins  st  dur  freq1 func1 freq2 func2  fuen1 db1 fuen2 db2 revg1 revg2 va1 va2 vd1 vd2 vr1 vr2 vi1 vi2    
  i2 133  .125 1770   13    1775  10      17   40   17    45   .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1770   13    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17   50   17    51  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +   .125 1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +   .125 1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +   .125 1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +   .125 1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +   .125 1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779   5       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    .    .     .   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    .    .     .   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    .    .     .   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    .    .     .   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    .    .     .   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17    .   17     .  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1770   13    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4 
  i2  +     .  1770   13    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   4       .    <    .     <     .    .   .   .   .  .   .   .   .   .
  i2  +     .  1772    6    1779   5       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    5    1565   6       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    2    1770   7       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    3    1560   8       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    3    1769   9       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568    4    1560   8       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   15    1775  10      17    <   17     <  .2   .2   .05  .05 2   2   4   6   3   4
  i2  +     .  1572    7    1579   7       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1772    6    1779  13       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1570    4    1565  15       .    <    .     <   .     .    .   .   .   .  .   .   .   .
  i2  +     .  1776    5    1770  14       .    <    .     <   .     .    .   .   .   .  .   .   .   . 
  i2  +     .  1564    2    1560  14       .    <    .     <   . . . . . . . . . .  
  i2  +     .  1764    3    1769  13       .    <    .     <   . . . . . . . . . .
  i2  +     .  1568   13    1560  11       .    <    .     <   . . . . . . . . . .
  i2  +     .  1770   10    1775  10      17   75   17     75  .2   .2   .05  .05 2   2   4   6   3   4
  e
</CsScore>
</CsoundSynthesizer>
